#include "shortest_path.hpp"

#include <filesystem>

int main() {
  const char * source = "output/links_main.dat";
  const char * source_r = "output/links_main_rev.dat";
  const char * source_r_raw = "output/links_main_rev_raw.dat";
  const char * source_raw = "output/links_main_raw.dat";
  const char * custom_excludes = "output/excludes_highway";

  Const_Nodes nodes,nodes_r;
  std::cout<<"Reading data"<<std::endl;
  if (std::filesystem::exists(source_raw)) {
    nodes.readfile_raw(source_raw);
  } else {
    nodes.readfile(source);
    nodes.writefile_raw(source_raw);
  }
  if (std::filesystem::exists(source_r_raw)) {
    nodes_r.readfile_raw(source_r_raw);
  } else {
    nodes_r.readfile(source_r);
    nodes_r.writefile_raw(source_r_raw);
  }
  
  std::cout<<"Initializing shortest path"<<std::endl;
  Shortest_path shortest(&nodes,&nodes_r);
  shortest.read_excludes(custom_excludes);
  std::cout<<"Computing shortest"<<std::endl;

  shortest.shortest_from(40);
  shortest.print_shortest_stats(std::cout);

  std::cout<<"From 1696582:"<<std::endl;
  shortest.shortest_from(nodes.index_of(1696582));
  shortest.print_shortest_stats(std::cout,6);

  std::cout<<"Best of childs:"<<std::endl;
  shortest.find_bestofchild(std::cout,nodes.index_of(1696582));
  shortest.print_center_stats(std::cout);
  
  shortest.sample_stats(std::cout,324000);
return 0;

  std::cout<<"Computing center"<<std::endl;
  shortest.find_center(std::cout);
  shortest.print_center_stats(std::cout);

  return 0;
}
