#include "const_nodes.hpp"
#include "tarjan.hpp"

#include <filesystem>

int main() {
  const char * source = "output/links_pp.dat";
  const char * source_r = "output/links_pp_rev.dat";
  const char * source_r_raw = "output/links_pp_rev_raw.dat";
  const char * source_raw = "output/links_pp_raw.dat";
  //const char * source_raw = "test/test_raw.dat";
  const char * scc_out = "output/scc_indices.dat";
  const char * scc_notmain = "output/outer_ids.dat";
  const char * scc_data = "output/scc_data.dat";
  const char * scc_shortest = "output/scc_shortest.dat";

  Const_Nodes nodes,nodes_r;
  std::cout<<"Reading data"<<std::endl;
  if (std::filesystem::exists(source_raw)) {
    nodes.readfile_raw(source_raw);
  } else {
    nodes.readfile(source);
    nodes.writefile_raw(source_raw);
  }
  if (std::filesystem::exists(source_r_raw)) {
    nodes_r.readfile_raw(source_r_raw);
  } else {
    nodes_r.readfile(source_r);
    nodes_r.writefile_raw(source_r_raw);
  }
  //for (size_t i = 0; i < nodes.size(); ++i) std::cout<<nodes.id(i)<<std::endl; return 0;

  Tarjan_SCC tarjan;
  std::cout<<"Computing SCC"<<std::endl;
  tarjan.compute_SCC(&nodes);
  tarjan.print_stats(std::cout);

  std::cout<<"Computing reduced grap"<<std::endl;
  tarjan.compute_reduced_graph(&nodes_r);
  std::cout<<"Computing path lenght"<<std::endl;
  tarjan.compute_path_lenght();
  std::cout<<"Computing connection to main"<<std::endl;
  tarjan.compute_connection_main();
  tarjan.print_rgraph_stats(std::cout);

  {
  std::ofstream out(scc_notmain);
  tarjan.print_id_outsize_main(out);
  out.close();
  }
  {
  std::ofstream out(scc_out);
  tarjan.print_data(out);
  out.close();
  }
  {
  std::ofstream out(scc_data);
  tarjan.print_rgraph_data(out);
  out.close();
  }

  std::cout<<"Compute shortest paths"<<std::endl;
  tarjan.compute_shortest_path(std::cout);
  tarjan.print_shortest_path_stats(std::cout);

  {
  std::ofstream out(scc_shortest);
  tarjan.print_shortest_path_data(out);
  out.close();
  }

  return 0;
}
