#ifndef CONST_NODES_HPP_INCLUDED
#define CONST_NODES_HPP_INCLUDED

#include <fstream>
#include "cset.hpp"

#include <iostream>

class Const_Nodes {
  public:

    void readfile(const char *datafile) {
      _ids.clear();
      _edges.clear();
      std::ifstream infile(datafile, std::ios_base::binary | std::ios_base::in);
      while(infile.peek() >= 0) { // read does not set eof if it reach the end (but does try to read past it)
        int id;
        infile.read(reinterpret_cast<char*>(&id), sizeof(int));
        _ids.add_ordered(id);
        _edges.emplace_back();
        int nb;
        infile.read(reinterpret_cast<char*>(&nb), sizeof(int));
        if (nb < 0) throw std::runtime_error("Invalid data");
        _edges.back().reserve(nb);
        for (int i = 0; i < nb; i++) {
          int to;
          infile.read(reinterpret_cast<char*>(&to), sizeof(int));
          _edges.back().add_ordered(to);
        }
        if (not _edges.back().validate_order()) throw std::runtime_error("Index not sorted");
      }
      infile.close();
      if (not _ids.validate_order()) throw std::runtime_error("Ids not sorted");
      // Convert id to index in _edges;
      for (size_t i = 0; i < _ids.size(); ++i) {
        Custom_set newedges;
        newedges.reserve(_edges[i].size());
        for (size_t j = 0; j < _edges[i].size(); ++j) {
          size_t tmp = _ids.find(_edges[i][j]);
          if (tmp == _ids.size()) throw std::runtime_error("Arrow to inexistant object");
          newedges.add_ordered(tmp);
        }
        _edges[i] = newedges;
      }
    }
    void readfile_raw(const char *datafile) {
      _ids.clear();
      _edges.clear();
      std::ifstream infile(datafile, std::ios_base::binary | std::ios_base::in);
      while(infile.peek() >= 0) { // read does not set eof if it reach the end (but does try to read past it)
        int id;
        infile.read(reinterpret_cast<char*>(&id), sizeof(int));
        _ids.add_ordered(id);
        _edges.emplace_back();
        int nb;
        infile.read(reinterpret_cast<char*>(&nb), sizeof(int));
        if (nb < 0) throw std::runtime_error("Invalid data");
        _edges.back().reserve(nb);
        for (int i = 0; i < nb; i++) {
          int to;
          infile.read(reinterpret_cast<char*>(&to), sizeof(int));
          _edges.back().add_ordered(to);
        }
        if (not _edges.back().validate_order()) throw std::runtime_error("Index not sorted");
      }
      infile.close();
      if (not _ids.validate_order()) throw std::runtime_error("Ids not sorted");
    }

    void writefile(const char *datafile) const {
      std::ofstream outfile(datafile, std::ios_base::binary | std::ios_base::out);
      for (size_t i = 0; i < _ids.size(); ++i) {
        int tmp;
        tmp = _ids[i];
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        tmp = _edges[i].size();
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        for (size_t j = 0; j < _edges[i].size(); ++j){
          tmp = _ids[_edges[i][j]];
          outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        }
      }
      outfile.close();
    }

    void writefile_raw(const char *datafile) const {
      std::ofstream outfile(datafile, std::ios_base::binary | std::ios_base::out);
      for (size_t i = 0; i < _ids.size(); ++i) {
        int tmp;
        tmp = _ids[i];
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        tmp = _edges[i].size();
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        for (size_t j = 0; j < _edges[i].size(); ++j){
          tmp = _edges[i][j];
          outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        }
      }
      outfile.close();
    }

    void writeids(const char *datafile) const {
      std::ofstream outfile(datafile, std::ios_base::binary | std::ios_base::out);
      for (size_t i = 0; i < _ids.size(); ++i) {
        outfile<<_ids[i]<<"\n";
      }
      outfile.close();
    }
    
    int id(size_t loc) const {
      return _ids[loc];
    }
    size_t index_of(int id) const {
      return _ids.find(id);
    }
    // Contains the index of connected vertices (not the id)
    const Custom_set & edges_of(size_t index) const {
      return _edges[index];
    }
    size_t size() const {
      return _ids.size();
    }

  private:
    Custom_set _ids;
    std::vector<Custom_set> _edges;
};


#endif

