#ifndef CSET_HPP_INCLUDED
#define CSET_HPP_INCLUDED

#include <vector>
#include <algorithm>

class Custom_set {
  public:
    void add_ordered(int i) { // must be greater than all other stored values
      _mset.push_back(i);
    }
    void reserve(size_t n) {
      _mset.reserve(n);
    }
    void clear() {
      _mset.clear();
    }
    void remove_index(size_t loc) {
      for (size_t i = loc; i + 1 < _mset.size(); ++i) {
        _mset[i] = _mset[i+1];
      }
      _mset.pop_back();
    }
    void remove_value(int val) {
      const auto itt = std::lower_bound(_mset.cbegin(),_mset.cend(),val);
      if (itt != _mset.cend() && *itt == val) { // value found
        remove_index(itt - _mset.cbegin());
      }
    }
    void replace_value(int val, int newval) { // search for val and replace with newval if found, delete val if newval already present
      const auto itt_rm = std::lower_bound(_mset.cbegin(),_mset.cend(),val);
      if (itt_rm != _mset.cend() && *itt_rm == val) { // value found
        size_t id_rm = itt_rm - _mset.cbegin();
        size_t id_new = std::lower_bound(_mset.cbegin(),_mset.cend(),newval) - _mset.cbegin();
        if (id_new < _mset.size() && _mset[id_new] == newval) { // newval already here (article link both a page and another that redirect to the former
          remove_index(id_rm);
          return;
        }
        if (id_rm == id_new || id_rm + 1 == id_new) { // same order
          _mset[id_rm] = newval;
        } else if (id_rm < id_new) { // swap until
          for (size_t i = id_rm; i + 1 < id_new; ++i) {
            _mset[i] = _mset[i+1];
          }
          _mset[id_new - 1] = newval;
        } else { // id_new < id_rm
          for (size_t i = id_rm; i > id_new; --i) {
            _mset[i] = _mset[i-1];
          }
          _mset[id_new] = newval;
        }
      }
    }
    void add_unordered(int val) { // faster to write, could be optimized
      if (_mset.size() == 0) {
        _mset.push_back(val);
        return;
      } 
      int max_val = _mset.back() + 1;
      _mset.push_back(max_val);
      replace_value(max_val,val);
    }

    int operator[](size_t i) const {
      return _mset[i];
    }
    size_t size() const {
      return _mset.size();
    }
    bool validate_order() const {
      if (_mset.size() == 0) return true;
      int old = _mset[0];
      for (size_t i = 1; i < _mset.size(); ++i) {
        if (_mset[i] <= old) return false;
        old = _mset[i];
      }
      return true;
    }
    bool search(int val) const {
      return std::binary_search(_mset.cbegin(),_mset.cend(),val);
    }
    size_t find(int val) const {
      auto search = std::lower_bound(_mset.cbegin(),_mset.cend(),val);
      if (search != _mset.cend() && *search == val) {
        return search - _mset.cbegin();
      } else {
        return _mset.size();
      }
    }

  private:
    std::vector<int> _mset;
};

#endif

