#include "nodes.hpp"

#include <iostream>
#include <fstream>
#include <vector>

int get_number() {
  int rv;
  while(true) {
    std::cin >> rv;
    if (not std::cin.fail()) return rv;
  }
}

int main() {
  const char * source = "output/links_pp.dat";
  const char * source_r = "output/links_pp_rev.dat";


  Nodes nodes_list;
  std::cout<<"Reading graph data"<<std::endl;
  nodes_list.readfile(source);
  std::cout<<"Reading reverse data"<<std::endl;
  Nodes nodes_reverse;
  nodes_reverse.readfile(source_r);

  std::cout<<"Ready"<<std::endl;
  char op;
  int val;
  while(true) {
    std::cin >> op;
    switch(op) {
      case 's':
        std::cout<<"Size of "<<std::endl;
        val = get_number();
        std::cout<<nodes_list.find(val)->second.size()<<" arrows from "<<val<<std::endl;
        break;
      case 'r':
        std::cout<<"Size of "<<std::endl;
        val = get_number();
        std::cout<<nodes_reverse.find(val)->second.size()<<" arrows to "<<val<<std::endl;
        break;
      case 'l':
      {
        std::cout<<"List of arrows from "<<std::endl;
        val = get_number();
        Custom_set const & edges = nodes_list.find(val)->second;
        for (size_t i = 0; i < edges.size(); ++i) {
          std::cout<<edges[i]<<std::endl;
        }
        break;
      }
      case 't':
      {
        std::cout<<"List of arrows from "<<std::endl;
        val = get_number();
        Custom_set const & edges = nodes_reverse.find(val)->second;
        for (size_t i = 0; i < edges.size(); ++i) {
          std::cout<<edges[i]<<std::endl;
        }
        break;
      }
      default:
      ;
    }
  }

  return 0;
}

