#include "const_nodes.hpp"

#include <iostream>
#include <fstream>
#include <vector>

int get_number() {
  int rv;
  while(true) {
    std::cin >> rv;
    if (not std::cin.fail()) return rv;
  }
}

int main() {
  //const char * source = "output/links_pp_raw.dat";
  //const char * source = "output/links_main_rev_raw.dat";
  const char * source = "output/links_main_raw.dat";

  Const_Nodes nodes_list;
  std::cout<<"Reading graph data"<<std::endl;
  nodes_list.readfile_raw(source);

  std::cout<<"Ready"<<std::endl;
  char op;
  int val,val2;
  while(true) {
    std::cin >> op;
    switch(op) {
      case 's':
        std::cout<<"Size of "<<std::endl;
        val = get_number();
        std::cout<<nodes_list.edges_of(val).size()<<" arrows from "<<val<<std::endl;
        break;
      case 'l':
      {
        std::cout<<"List of arrows from "<<std::endl;
        val = get_number();
        Custom_set const & edges = nodes_list.edges_of(val);
        for (size_t i = 0; i < edges.size(); ++i) {
          std::cout<<edges[i]<<std::endl;
        }
        break;
      }
      case 'i':
      {
        std::cout<<"Is (int) in (int) "<<std::endl;
        val = get_number();
        val2 = get_number();
        std::cout<<nodes_list.edges_of(val2).search(val);
        break;
      }
      default:
      ;
    }
  }

  return 0;
}

