#ifndef NODES_HPP_INCLUDED
#define NODES_HPP_INCLUDED

#include <fstream>
#include <map>
//#include <unordered_map>
#include "cset.hpp"

#include <iostream>

class Nodes {
  public:

    void readfile(const char *datafile) {
      std::ifstream infile(datafile, std::ios_base::binary | std::ios_base::in);
      while(infile.peek() >= 0) { // read does not set eof if it reach the end (but does try to read past it)
        int id;
        infile.read(reinterpret_cast<char*>(&id), sizeof(int));
        Custom_set point_to;
        int nb;
        infile.read(reinterpret_cast<char*>(&nb), sizeof(int));
        if (nb < 0) continue;
        point_to.reserve(nb);
        for (int i = 0; i < nb; i++) {
          int to;
          infile.read(reinterpret_cast<char*>(&to), sizeof(int));
          point_to.add_ordered(to);
        }
        if (not point_to.validate_order()) throw std::runtime_error("Index not sorted");
        _arrows.emplace_hint(_arrows.cend(),id,point_to);
      }
      infile.close();
    }
    template<typename Iter> // construct from other node
    void fill_reverse(Iter begin,Iter end) {
      for (auto it = begin; it != end; ++it) {
        int id = it->first;
        Custom_set point_from;
        _arrows.emplace_hint(_arrows.cend(),id,point_from);
      } // Create list of object
      for (auto it = begin; it != end; ++it) {
        for (size_t i = 0; i < it->second.size(); ++i) {
          try {
            _arrows.at(it->second[i]).add_ordered(it->first);
          } catch (std::out_of_range) {
            std::cerr<<it->first<<" link to inexistant "<<it->second[i]<<std::endl;
          }
        }
      }
      validate_order(); // throw if not ordered
    }

    void writefile(const char *datafile) const {
      std::ofstream outfile(datafile, std::ios_base::binary | std::ios_base::out);
      for (auto it = _arrows.cbegin(); it != _arrows.cend(); ++it) {
        int tmp;
        tmp = it->first;
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        tmp = it->second.size();
        outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        for (size_t i = 0; i < it->second.size(); ++i){
          tmp = it->second[i];
          outfile.write(reinterpret_cast<char*>(&tmp),sizeof(int));
        }
      }
      outfile.close();
    }

    // redirect to 0 to erase
    void apply_redirect(int id, int newid, const Nodes &reverse) {
      {
        auto it = _arrows.find(id);
        if (it == _arrows.end()) {
          std::cerr<<"Redirect "<<id<<" failed."<<std::endl;
          return;
        } 
        _arrows.erase(it); // remove the redirect element
      }
      // replace each occurence with the redirected value
      {
        Custom_set const &rev = reverse.arrows_from(id); // get the list of node pointing to redirected 
        for (size_t i = 0; i < rev.size(); ++i) {
          auto it = _arrows.find(rev[i]);
          if (it == _arrows.end()) continue;
          if (newid == 0) { // link to unavailable page
            it->second.remove_value(id);
          } else {
            it->second.replace_value(id,newid);
          }
          if (not it->second.validate_order()) throw std::runtime_error("Dev: Custem_set remove or replace failed");
        }
      }
    }

    void validate_order() const {
      auto it = _arrows.begin();
      int old = it->first;
      if (not it->second.validate_order()) throw std::runtime_error("Data not sorted");
      for (++it; it != _arrows.end(); ++it) {
        if (it->first <= old) throw std::runtime_error("Objects not sorted");
        old = it->first;
        if (not it->second.validate_order()) throw std::runtime_error("Data not sorted");
      }
    }

    const Custom_set & arrows_from(int id) const {
      return _arrows.at(id);
    }

  private:
    std::map<int,Custom_set> _arrows;
    //std::unordered_map<int,Custom_set> _arrows;
    // try unordered map? faster lookup

  public:
    typename decltype(_arrows)::const_iterator cbegin() const {
      return _arrows.cbegin();
    }
    typename decltype(_arrows)::const_iterator cend() const {
      return _arrows.cend();
    }
    typename decltype(_arrows)::const_iterator find(int id) const {
      return _arrows.find(id);
    }
};


#endif

