#include "ids.hpp"
#include "parser_refs.hpp"

int main() {
  const char* data = "../output/article_list.dat";
  //const char* source = "/mnt/data/enwiki-latest-pages-articles.xml";
  const char* source = "/mnt/data/frwiki-latest-pages-articles.xml";
  const char* dest = "../output/links.dat";
  const char* dest_fr = "../output/links_fr.dat";
  const char* errfile = "/mnt/data/invalid.dat";

  idsconv ids(data);
  readbuffer rbuff(source);

  parser_refs parser(&rbuff,&ids,dest,dest_fr);

  parser.parse();

  std::ofstream outerr(errfile);
  parser.write_inv_to_file(outerr);
  outerr.close();
  
  return 0;
}

