#ifndef READER_HPP_INCLUDED
#define READER_HPP_INCLUDED
#include <fstream>
#include <memory>

class readbuffer {
  public:
    readbuffer(const char * filename, size_t buffsize = 1<<20) : _bsize(buffsize){
      _buffer = static_cast<char*>(malloc(_bsize));
      if (_buffer == nullptr){
        throw std::runtime_error("Memory alloc failed");
      }
      _fh.open(filename);
      if (not _fh.is_open()){
        free(_buffer);
        throw std::runtime_error("File open failed");
      }
    }
    ~readbuffer() {
      _fh.close();
      free(_buffer);
    }
    
    char get() {
      if (_itt == 0) {
        _fh.read(_buffer, _bsize);
        _itt = _fh.gcount();
        _bsize = _itt;
      }
      char rv = _buffer[_bsize - _itt];
      --_itt;
      if (_itt == 0 && _fh.eof()) _eof = true;
      return rv;
    }

    bool full() const {
      return not _eof;
    }

  private:
    std::ifstream _fh;
    char * _buffer;
    size_t _bsize;
    size_t _itt = 0;

    bool _eof = false;
};

#endif

