#include "nodes.hpp"

#include <iostream>
#include <fstream>
#include <vector>

int main() {
  const char * source = "output/links_pp.dat";
  const char * source_r = "output/links_pp_rev.dat";
  const char * dest = "output/links_main.dat";
  const char * dest_r = "output/links_main_rev.dat";
  const char * special = "output/outer_ids.dat";

  std::vector<int> sp_ids;
  std::ifstream f_sp_list(special);
  while(not f_sp_list.eof()) {
    int id;
    f_sp_list >> id;
    f_sp_list >> std::ws;
    sp_ids.push_back(id);
  }
  f_sp_list.close();

  Nodes nodes_list;
  std::cout<<"Reading graph data"<<std::endl;
  nodes_list.readfile(source);
  {
    std::cout<<"Reading reverse data"<<std::endl;
    Nodes nodes_reverse;
    nodes_reverse.readfile(source_r);
    std::cout<<"Applying redirects"<<std::endl;
    for (size_t i = 0; i < sp_ids.size(); i++) {
      std::cout<<"\r"<<sp_ids[i]<<std::flush;
      nodes_list.apply_redirect(sp_ids[i],0,nodes_reverse);
    }
  }
  std::cout<<std::endl<<"Writing postproc data"<<std::endl;
  nodes_list.writefile(dest);
  std::cout<<"Reversing"<<std::endl;
  Nodes nodes_reverse;
  nodes_reverse.fill_reverse(nodes_list.cbegin(),nodes_list.cend());
  std::cout<<"Writing reversed data"<<std::endl;
  nodes_reverse.writefile(dest_r);

  return 0;
}

