#include "nodes.hpp"

#include <iostream>
#include <fstream>
#include <vector>

int main() {
  const char * source = "output/links.dat";
  const char * source_r = "output/links_rev.dat";
  const char * dest = "output/links_pp1.dat";
  const char * dest_r = "output/links_pp1_rev.dat";
  const char * redir = "output/redirects.dat";
  const char * first_link = "output/links_fr.dat";

  std::vector<int> redir_ids,redir_to;
  {
    std::ifstream ffirstlink(first_link);
    std::vector<int> ids,ids_fr;
    while(not ffirstlink.eof()) {
      int id, rid;
      ffirstlink >> id;
      ffirstlink >> rid;
      ids.push_back(id);
      ids_fr.push_back(rid);
      ffirstlink >> std::ws;
    }
    ffirstlink.close();
    std::ifstream fredir(redir);
    size_t i = 0;
    while(not fredir.eof()) {
      int id;
      fredir >> id;
      redir_ids.push_back(id);
      for (; i < ids.size(); ++i) { // we assume ids to be sorted
        if (ids[i] == id) {
          if (ids_fr[i] == id) {
            std::cerr<<"Found autoredirect: "<<id<<std::endl;
            redir_to.push_back(0);
          } else {
            redir_to.push_back(ids_fr[i]);
          }
          break;
        }
      }
      fredir >> std::ws;
    }
    if (not redir_ids.size() == redir_to.size()) throw std::runtime_error("Missing id in first_ref list");
    fredir.close();
  }
  // Resolve nested redirects
  {
    std::cout<<"Fixing redirects"<<std::endl;
    for (size_t i = 0; i < redir_to.size();++i) {
      while (std::binary_search(redir_ids.cbegin(),redir_ids.cend(),redir_to[i])) {
        auto search = std::lower_bound(redir_ids.cbegin(),redir_ids.cend(),redir_to[i]);
        std::cout<<redir_ids[i]<<"->"<<redir_to[i]<<"->"<<redir_to[search - redir_ids.cbegin()]<<std::endl;

        redir_to[i] = redir_to[search - redir_ids.cbegin()];
        if (redir_to[i] == redir_ids[i]) {
          std::cout<<"Removed cyclic reference"<<std::endl;
          redir_to[i] = 0;
        }
      }
    }
  }

  Nodes nodes_list;
  std::cout<<"Reading graph data"<<std::endl;
  nodes_list.readfile(source);
  {
    std::cout<<"Reading reverse data"<<std::endl;
    Nodes nodes_reverse;
    nodes_reverse.readfile(source_r);
    std::cout<<"Applying redirects"<<std::endl;
    for (size_t i = 0; i < redir_ids.size(); i++) {
      std::cout<<"\r"<<redir_ids[i]<<std::flush;
      nodes_list.apply_redirect(redir_ids[i],redir_to[i],nodes_reverse);
    }
  }
  std::cout<<std::endl<<"Writing postproc data"<<std::endl;
  nodes_list.writefile(dest);
  std::cout<<"Reversing"<<std::endl;
  Nodes nodes_reverse;
  nodes_reverse.fill_reverse(nodes_list.cbegin(),nodes_list.cend());
  std::cout<<"Writing reversed data"<<std::endl;
  nodes_reverse.writefile(dest_r);

  return 0;
}

